/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.std;

import com.quantumdata.std.IRemoteConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class SocketConnection
implements IRemoteConnection {
    public static final int CMD_PORT_NUM = 6500;
    public static final int LOG_PORT_NUM = 40000;
    private Socket m_socket = new Socket();
    private String m_host;
    private int m_portNumber;
    private boolean m_isConnected;
    private String m_errorMessage;

    public SocketConnection(String string) {
        this.m_host = string;
        this.m_isConnected = false;
        this.m_portNumber = 6500;
        this.m_errorMessage = "";
    }

    public SocketConnection(String string, int n) {
        this.m_host = string;
        this.m_isConnected = false;
        this.m_portNumber = n;
        this.m_errorMessage = "";
    }

    public String getName() {
        return this.m_host;
    }

    public boolean isEchoing() {
        return false;
    }

    public String getEndOfResponse() {
        return "\r\n;";
    }

    public String getEndOfPrompt() {
        return "";
    }

    public void connect() throws Exception {
        this.connect(0);
    }

    public void connect(int n) throws Exception {
        if (this.m_isConnected) {
            return;
        }
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.m_host, this.m_portNumber);
        if (inetSocketAddress.isUnresolved()) {
            this.m_errorMessage = "Unable to resolve address " + this.m_host + ":" + this.m_portNumber;
            throw new Exception(this.m_errorMessage);
        }
        this.m_socket = new Socket();
        this.m_socket.setReuseAddress(true);
        this.m_socket.setKeepAlive(true);
        try {
            this.m_socket.connect(inetSocketAddress, n);
        }
        catch (Exception exception) {
            this.m_errorMessage = exception.getMessage();
            throw exception;
        }
        if (!this.m_socket.isConnected()) {
            this.m_errorMessage = "Unable to connect";
            throw new Exception(this.m_errorMessage);
        }
        this.m_isConnected = true;
    }

    public void disconnect() throws Exception {
        this.m_isConnected = false;
        this.m_socket.close();
    }

    public boolean isConnected() {
        return this.m_isConnected;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.m_isConnected) {
            return null;
        }
        return this.m_socket.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        if (!this.m_isConnected) {
            return null;
        }
        return this.m_socket.getInputStream();
    }

    public String getHostName() {
        return this.m_host;
    }

    public void setHostName(String string) {
        if (this.m_isConnected) {
            try {
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_host = string;
    }

    public IRemoteConnection getAlternateChannel() {
        return new SocketConnection(this.m_host, this.m_portNumber);
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }
}

